/*
 * Decompiled with CFR 0.152.
 */
package com.megacrit.cardcrawl.cards.blue;

import com.megacrit.cardcrawl.actions.common.GainBlockAction;
import com.megacrit.cardcrawl.cards.AbstractCard;
import com.megacrit.cardcrawl.characters.AbstractPlayer;
import com.megacrit.cardcrawl.core.CardCrawlGame;
import com.megacrit.cardcrawl.dungeons.AbstractDungeon;
import com.megacrit.cardcrawl.localization.CardStrings;
import com.megacrit.cardcrawl.monsters.AbstractMonster;
import com.megacrit.cardcrawl.ui.panels.EnergyPanel;

public class IronCross
extends AbstractCard {
    public static final String ID = "IronCross";
    private static final CardStrings cardStrings = CardCrawlGame.languagePack.getCardStrings("IronCross");
    public static final String NAME = "Iron Cross";
    public static final String DESCRIPTION = "Gain !B! Block X times.";
    private static final int COST = -1;
    private static final int BASE_BLOCK = 5;
    private static final int POOL = 1;

    public IronCross() {
        super(ID, NAME, null, null, -1, DESCRIPTION, AbstractCard.CardType.SKILL, AbstractCard.CardColor.BLUE, AbstractCard.CardRarity.UNCOMMON, AbstractCard.CardTarget.SELF, 1);
        this.baseBlock = 5;
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m, int energyAmount) {
        int effect = energyAmount;
        if (p.hasRelic("Chemical X")) {
            effect += 2;
            p.getRelic("Chemical X").flash();
        }
        if (effect > 0) {
            for (int i = 0; i < effect; ++i) {
                AbstractDungeon.actionManager.addToBottom(new GainBlockAction(p, p, this.block));
            }
            if (!this.freeToPlayOnce) {
                p.energy.use(EnergyPanel.totalCount);
            }
        }
    }

    @Override
    public void use(AbstractPlayer p, AbstractMonster m) {
        this.use(p, m, EnergyPanel.totalCount);
    }

    @Override
    public AbstractCard makeCopy() {
        return new IronCross();
    }

    @Override
    public void upgrade() {
        if (!this.upgraded) {
            // empty if block
        }
    }
}

